---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：17-Tasks Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行78-80（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行73-75（コンストラクタ nodesInCluster）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行93-101（doCatRequest処理）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行94（generateListTasksRequest）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行118-149（テーブルヘッダー定義）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行119（detailed パラメータ）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行143-146（detailed時追加カラム）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行153-185（buildRow処理）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行161-165（parentTaskId判定）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行172-177（node==null時のガード）
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行178（X_OPAQUE_ID取得）
- E-12: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行187-195（buildGroups再帰処理）
- E-13: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行190（startTime昇順ソート）
- E-14: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行103-115（RESPONSE_PARAMS detailed追加）
- E-15: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` 行151（FORMATTER HH:mm:ss UTC）
- E-16: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行18（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/tasks | E-01 | ○ |
| C-02 | コンストラクタでSupplier<DiscoveryNodes>を受け取る | E-02 | ○ |
| C-03 | generateListTasksRequest()でリクエスト生成 | E-04 | ○ |
| C-04 | detailedパラメータで追加カラム | E-06, E-07 | ○ |
| C-05 | 通常モードは15カラム | E-05 | ○ |
| C-06 | detailedモードは17カラム（+description, resource_stats） | E-07 | ○ |
| C-07 | parentTaskId未設定時は"-" | E-09 | ○ |
| C-08 | ノード離脱時（node==null）はIP/ポート/名前/バージョンが"-" | E-10 | ○ |
| C-09 | X_OPAQUE_IDのデフォルト値は"-" | E-11 | ○ |
| C-10 | buildGroups()は再帰的に子タスク処理 | E-12 | ○ |
| C-11 | タスクグループはstartTime昇順ソート | E-13 | ○ |
| C-12 | detailed は追加のRESPONSE_PARAMSとして登録 | E-14 | ○ |
| C-13 | timestampはHH:mm:ss UTC形式 | E-15 | ○ |
| C-14 | running_timeはTimeValue.timeValueNanos使用 | E-08 | ○ |
| C-15 | full_id=falseでノードID4文字短縮 | E-08 | ○ |
| C-16 | id はデフォルト非表示 | E-05 | ○ |
| C-17 | running_time_ns はデフォルト非表示 | E-05 | ○ |
| C-18 | node_id はデフォルト非表示 | E-05 | ○ |
| C-19 | port はデフォルト非表示 | E-05 | ○ |
| C-20 | version はデフォルト非表示 | E-05 | ○ |
| C-21 | x_opaque_id はデフォルト非表示 | E-05 | ○ |
| C-22 | アクション名は cat_tasks_action | E-01 | ○ |
| C-23 | ソースファイルは全204行 | E-12 | ○ |
| C-24 | cluster:monitor/tasks/lists 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・再帰処理・ソート（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] 通常/detailedモードのカラム数が正確か確認
- [ ] buildGroups再帰処理の記述が正確か確認
- [ ] ノード離脱時のフォールバック動作確認
- [ ] セキュリティ権限名の確認
